﻿var ROW_NUM = 16;

/****base colume index****/
var EMMG_NAME = 1;
var CAS_ID = 2;
var SUB_CAS_ID = 3;
var TCP_PORT = 6;
var UDP_PORT = 7;
var EMMG_BIT = 8
var EMM_DESCRIP = 10;
/**end**/

var language;
window.onload = function()
{
	var args = getArgs();
	var group = args["group"];
	var apply = document.getElementById("Apply");
	language = document.getElementById("language").value;
	applyDispay(group, apply);
	PageLoadHandler();
}

function PageLoadHandler()
{
	window.status = "Retrieving data, please wait....";
	document.body.style.cursor = "wait";
	
	DisableApply(true);
	DisableReset(true);
	
	GetEmmConfigRows();
	
	document.body.style.cursor = "auto";
	window.status = "Done";
	DisableReset(false);
	g_EmmConfigRows.length = 0;
}


function GetEmmConfigRows()
{
	var xmlhttp = false;
	xmlhttp = getHTTPObject();
	var getParams = "type=30&cmd=1&getEmmConfig=1";

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if((xmlhttp.readyState == 4) && (xmlhttp.status == 200))
		{

			var response = xmlhttp.responseText;
			var emmConfigInfo = response.slice(7, -8).split("&");
			var emmLength = emmConfigInfo.length;
			for(var i = 0; i < emmLength; i++)
			{
				var saveRowString = emmConfigInfo[i];
				saveRowString = "C," + saveRowString; // When loading the rows are Clean
				g_EmmConfigRows.push(saveRowString);
			}
			RenderBaseTable();
			return true;
		}
	}
	xmlhttp.send(getParams);
	return true;
}

var g_EmmConfigRows = [];	// Contains array of strings - each element containing , separated values
function DisableApply(bDisable)
{
	disabledButton(document.getElementById("Apply"), bDisable);
}


function DisableReset(bDisable)
{
	disabledButton(document.getElementById("Reset"), bDisable);
}


function PerformReload()
{
	PageLoadHandler();
}

var modifyCount = 0;
var modifyRows = [];
function PerformApply()
{
	if(paramCheck() == false)
	{
		return;
	}
	var len = g_EmmConfigRows.length;
	for(var i = 0; i < len; i++)
	{
		// Modified row
		if(g_EmmConfigRows[i].slice(0, 1) == "M")
		{
			var modRow;
			var data = g_EmmConfigRows[i].split(",");
			
			DisableApply(true);
			DisableReset(true);
			window.status = "Applying settings, please wait...";
			document.body.style.cursor = "wait";
			// Modified row
			modifyCount++;

			modRow = i + "," + data[EMMG_NAME];
			for(var j = CAS_ID; j < data.length; j++)
			{
				modRow = modRow + "," + data[j];
			}
			modifyRows.push(modRow);
		}//else if
	}
	
	setEmmData();
}
function paramCheck()
{
 	var returnFlag;
	var $emmData;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		$emmData = $("#j" + i);
		returnFlag = ValidateParam($("#b" + i), "INT_DEC_HEX", 0, 65535, "<CAS ID>", "<CAS ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#c" + i), "INT_DEC_HEX", 0, 65535, "<SUB CAS ID>", "<SUB CAS ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#f" + i), "INT_DEC", 1, 65535, "<TCP Port>", "<TCP端口>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#g" + i), "INT_DEC", 1, 65535, "<UDP Port>", "<UDP端口>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#h" + i), "INT_DEC", 0, 10000, "<EMM Bitrate>", "<EMM码率>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($emmData, "INT_HEX_NULL", 0, 0, "<EMM Private Description>", "<EMM私用描述>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($emmData, "LENGTH", 0, 128, "<EMM Private Data>", "<EMM私用描述>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if($emmData.val().length % 2 != 0)
		{
			if(language == ENGLISH)
			{
				alert("The length of <EMM Private Data> should be a even number!");
			}
			else
			{
				alert("<EMM私用描述>只能输入偶数个字符!");
			}
			return false; 
		}
	}
	
	return true;
}
var postString = "";
var postModifyString = "";

function setEmmData()
{
	var len = modifyRows.length;
	
	postModifyString = modifyRows[0];
	for(var i = 1; i < len; i++)
	{
		postModifyString = postModifyString + "|" + modifyRows[i];
	}
	postString = "MODIFY#" + len + "#" + postModifyString;		
	PostStreamMapRows(postString);
}

function PostStreamMapRows(sValueString)
{
	var params = "type=30&cmd=2&emmSetString=" + sValueString

	var xmlhttp = false;
	
	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);

	xmlhttp.onreadystatechange = function()
   	{
    	if(xmlhttp.readyState == 4)
    	{
			if(language == 0)
			{
				alert("EMM config rows modified successfully.");
			}
			else
			{
				alert("EMM参数设置成功。");
			}
			window.location.reload();
			return true;
		}
	}
	xmlhttp.send(params);
	return false;
}



function RenderBaseTable()
{
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i >= g_EmmConfigRows.length)
		{
			RenderBlankRow(i);
			continue;
		}
		RenderBaseRow(i, g_EmmConfigRows[i]);
	}
}

function RenderBaseRow(rowNo, rowData)
{
	var fields = rowData.split(",");
	var smapRow = document.getElementById("BaseSettings").rows[1 + rowNo];
	var smapRowCells = smapRow.cells;

	for (var i = EMMG_NAME; i <= EMM_DESCRIP; i++)
	{
		smapRowCells[i].firstChild.value = fields[i];
	}
	
	if(fields[0] == "M")
	{
		// Highlight modified row
		smapRow.style.backgroundColor = "yellow";
	}
	else
	{
		// Normal row
		smapRow.style.backgroundColor = "white";
	}

	smapRow.style.visibility = "visible";
}


function RenderBlankRow(rowNo)
{
	var smapRow = document.getElementById("BaseSettings").rows[1 + rowNo];
	smapRow.style.visibility = "hidden";
}

function OnStreamMapCellChange(obj)
{
	var rowNo = parseInt(obj.id.substr(1), 10); // if id is "a2" rowNo will be 2
	var fieldIndex = obj.id.charCodeAt(0) - 97 + 1; // 97 is the char code for "a"
	var rowValue = g_EmmConfigRows[rowNo]; // This will be , separated
	var rowFields = rowValue.split(",");

	
	if(fieldIndex == EMMG_NAME)
	{
		if(validateName(obj.value, 0, language) == false)
		{
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	else if(fieldIndex == CAS_ID)
	{
		returnFlag = ValidateParam($(obj), "INT_DEC_HEX", 0, 65535, "<CAS ID>", "<CAS ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else if(fieldIndex == SUB_CAS_ID)
	{
		returnFlag = ValidateParam($(obj), "INT_DEC_HEX", 0, 65535, "<Sub CAS ID>", "<Sub CAS ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}

	else if(fieldIndex == TCP_PORT)
	{
		if(validateNumber(obj.value) == false)
		{
			if(language == 0)
			{
				alert("Invalid number. Please enter a valid numeric value for TCP Port.");
			}
			else
			{
				alert("无效的数字，请输入一个有效的TCP端口。");
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
		if((obj.value< 0) || (obj.value > 65535))
		{
		if(language == 0)
		{
			alert("Valid range for TCP Port is 0 - 65535.");
		}
		else
		{
			alert("TCP端口的范围是0 - 65535。");
		}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	
	else if(fieldIndex == UDP_PORT)
	{
		if(validateNumber(obj.value) == false)
		{
			if(language == 0)
			{
				alert("Invalid number. Please enter a valid numeric value for UDP Port.");
			}
			else
			{
				alert("无效的数字，请输入一个有效的UDP端口。");
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
		if((obj.value< 0) || (obj.value > 65535))
		{
			if(language == 0)
			{
				alert("Valid range for UDP Port is 0 - 65535.");
			}
			else
			{
				alert("UDP端口的范围是0 - 65535。");
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	
	else if(fieldIndex == EMMG_BIT)
	{
		if(validateNumber(obj.value) == false)
		{
			if(language == 0)
			{
				alert("Invalid number. Please enter a valid numeric value for EMMG Bitrate.");
			}
			else
			{
				alert("无效的数字，请输入一个有效的EMMG码率。");
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
		if((obj.value< 0) || (obj.value > 10000))
		{
			if(language == 0)
			{
				alert("Valid range for EMMG Bitrate is 0 - 10000.");
			}
			else
			{
				alert("EMMG码率的范围是0 - 10000。");
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	
	else if(fieldIndex == EMM_DESCRIP)
	{
		/*if(validateString(obj.value, 64, language) == false)
		{
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}*/
		var patten = /^([A-Fa-f0-9])*$/;
		if(!patten.test(obj.value))
		{
			if(language == 0)
			{
				alert("EMM Description should be Hexadecimal non-negative integer!");
			}
			else
			{
				alert("EMM私用描述应该是十六进制非负整数！");
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
		if(obj.value.length > 64)
		{
			if(language == 0)
			{
				alert("The digit number of the input is no more than 128!");
			}
			else
			{
				alert("输入应小于128位！");
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	// Update the row with the new value
	rowFields[fieldIndex] = obj.value;
	rowFields[0] = "M";

	// Build a new row string and update g_EmmConfigRows
	var newRowString = rowFields[0];
	for(var i = 1; i < rowFields.length; i++)
	{
		newRowString = newRowString + "," + rowFields[i];
	}

	g_EmmConfigRows[rowNo] = newRowString;

	RenderBaseRow(rowNo, g_EmmConfigRows[rowNo]);

	DisableApply(false);
	DisableReset(false);
}


